#property copyright "InstaForex"
#property link      "http://www.instaforex.com/"

#property indicator_separate_window
#property indicator_buffers 1
#property indicator_color1 Red
#property indicator_width1 2
// ----
input int IndPeriod = 14;
input int CountBars = 300;
int _CountBars = 0;
// ---- buffers
double dpo[];

// +------------------------------------------------------------------+
// | Custom indicator initialization function                         |
// +------------------------------------------------------------------+
int init()
{
	string short_name;
	// ---- indicator line
	SetIndexStyle(0, DRAW_LINE);
	SetIndexBuffer(0, dpo);
	// ---- name for DataWindow and indicator subwindow label
	short_name = "IFX DPO(" + IntegerToString(IndPeriod) + ")";
	IndicatorShortName(short_name);
	SetIndexLabel(0, short_name);
	// ----
	_CountBars = CountBars;
	if (_CountBars >= Bars)
		_CountBars = Bars;
	SetIndexDrawBegin(0, Bars - _CountBars + IndPeriod + 1);
	// ----
	return (0);
}

// +------------------------------------------------------------------+
// | DPO                                                              |
// +------------------------------------------------------------------+
int start()
{
	int i, counted_bars = IndicatorCounted();
	int t_prd;
	// ----
	if (Bars <= IndPeriod)
		return (0);
	// ---- initial zero
	if (counted_bars < IndPeriod)
	{
		for (i = 1; i <= IndPeriod; i++)
			dpo[_CountBars - i] = 0.0;
	}
	// ----
	i = _CountBars - IndPeriod - 1;
	t_prd = IndPeriod / 2 + 1;
	// ----
	while (i >= 0)
	{
		dpo[i] = Close[i] - iMA(NULL, 0, IndPeriod, t_prd, MODE_SMA, PRICE_CLOSE, i);
		i--;
	}
	return (0);
}
// +------------------------------------------------------------------+